#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Mayan Acid RideMod01.fsh  by   Mojomajor
//https://www.shadertoy.com/view/ftdyWH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// "ShaderToy Tutorial - Hexagonal Tiling"
// by Martijn Steinrucken aka BigWings/CountFrolic - 2019
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//
// This shader is part of a tutorial on YouTube
// https://youtu.be/VmrIDyYiJBA

#define MIRROR_X 1
#define MIRROR_Y 1
#define ACID_MODE 0 // 0 = TRANCE MODE
#define EPILEPSY 0
#define POLAR 0 // less faces :-(

float HexDist(vec2 p)
{
    p = abs(p);

    float c = dot(p, normalize(vec2(1, 1.73)));
    c = max(c, p.x);

    return c;
}

vec4 HexCoords(vec2 uv)
{
    vec2 r = vec2(1, 1.73);
    vec2 h = r * .5;

    vec2 a = mod(uv, r) - h;
    vec2 b = mod(uv - h, r) - h;

    vec2 gv = dot(a, a) < dot(b, b) ? a : b;

    float x = atan(gv.x, gv.y);
    float y = .5 - HexDist(gv);
    vec2 id = uv - gv;
    return vec4(x, y, id.x, id.y);
}
mat2 rotate2d(float _angle)
{
    return mat2(cos(_angle), -sin(_angle),
                sin(_angle), cos(_angle));
}
float random(in vec2 _st)
{
    return fract(sin(dot(_st.xy,
                         vec2(12.9898 * sin(iTime / 600000.), 78.233))) *
                 43758.5453123);
}
float noise(in vec2 _st)
{
    vec2 i = floor(_st);
    vec2 f = fract(_st);

    // Four corners in 2D of a tile
    float a = random(i);
    float b = random(i + vec2(1., 0.));
    float c = random(i + vec2(0., 1.));
    float d = random(i + vec2(1., 1.));

    vec2 u = f * f * (3. - 2. * f);

    return mix(a, b, u.x) +
           (c - a) * u.y * (1. - u.x) +
           (d - b) * u.x * u.y;
}
uint noiseSquirrel3(in int position)
{
    uint BIT_NOISE1 = uint(0xB5297A4D);
    uint BIT_NOISE2 = uint(0x68E31DA4);
    uint BIT_NOISE3 = uint(0x1B56C4E9);

    uint mangled = uint(position);
    mangled *= BIT_NOISE1;
    mangled ^= (mangled >> 8);
    mangled += BIT_NOISE2;
    mangled ^= (mangled << 8);
    mangled *= BIT_NOISE3;
    mangled ^= (mangled >> 8);

    return mangled;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - .5 * iResolution.xy) / iResolution.y;
    uv*=1.0;
    
    vec3 ampl = texture2D(texture0,uv).xyz;
    vec3 col = vec3(0);
    uv.x -=iMouse.y/iResolution.y;
    float acidDrop = 0.;
    // polar coordinates

#if ACID_MODE
    acidDrop = 10.*(iMouse.x/iResolution.y);
#endif
    uv *= 20.-acidDrop;
#if MIRROR_X
    uv.x = abs(uv.x);
#endif
#if MIRROR_Y
    uv.y = abs(uv.y);
#endif

    // vec4 hc = HexCoords(uv*sin(noise(uv)));
    float n1 = noise(uv);
    float n2 = float(noiseSquirrel3(int(iTime * 100.))) / 3.;
#if POLAR
    uv = vec2(atan(uv.x,uv.y), length(uv));
#endif
    vec4 hc = HexCoords(uv * sin(n1));
       
#if EPILEPSY
    float d = length(vec2(n1*uv.x,n2*uv.y));
    hc /= .5*d/999999900.;
#else
    hc /= .5;
#endif
uv *= sin(mix(n1, n2, cos(iTime) * .5 + n1));
    float c = smoothstep(.01, .5, hc.y * cos(hc.z * hc.w + iTime) * .5 + .20);
#if ACID_MODE
    hc.zw = hc.xy*rotate2d(22.4);
    hc.xy = hc.zw*rotate2d(32.2),
    col = hc.xyz;
#endif
    col += c;
    col *= vec3(abs(sin(uv.x + iTime)), cos(hc.w * iTime / 200.), tan(hc.z * iTime / 300.));

    fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

